/*
*       *************************************************************
*       **                                                         **
*       **        Copyright (C) 2017, Advantest Corporation        **
*       **              PROPRIETARY AND TRADE SECRET               **
*       **      Published only in a limited, copyright sense.      **
*       **                                                         **
*       *************************************************************
*/

#ifndef AIRLOGGERAPI_H
#define AIRLOGGERAPI_H

#ifndef AIRLOGGERAPI_API
    #ifdef AIRLOGGERAPI_EXPORTS
        #define AIRLOGGERAPI_API __declspec(dllexport)
    #else
        #define AIRLOGGERAPI_API __declspec(dllimport)
    #endif
#endif

#ifndef _WINDEF_
    typedef unsigned long DWORD;
    typedef int BOOL;
    typedef long LPARAM;
#endif

#ifndef CALLBACK
    #define CALLBACK __stdcall
#endif

#ifndef WINAPI
    #define WINAPI __stdcall
#endif



// Error Code
#define AIRLOGGER_SUCCESS             0
#define AIRLOGGER_INVALID_PARAMETER	  -1
#define AIRLOGGER_INVALID_STATE	      -2
#define AIRLOGGER_COMMUNICATION_ERROR -3
#define AIRLOGGER_UNREGISTERD_ROM	  -4
#define AIRLOGGER_MULTIPLE_PC_COMMUNICATION_UNIT -5

#define AIRLOGGER_NOT_FIND_ROUTER	  -6
#define AIRLOGGER_DUPLICATE_ROUTER_IP -7
#define AIRLOGGER_INVALID_TCP_ACK_FREQ -16

// Status Code
#define AIRLOGGER_STATE_NOT_INITIALIZED 0
#define AIRLOGGER_STATE_NOT_READY       1
#define AIRLOGGER_STATE_READY           2
#define AIRLOGGER_STATE_MEASURING       3
#define AIRLOGGER_STATE_INITIALIZED_MEASURING       4

// Temperature Unit
#define AIRLOGGER_TEMPERATURE_UNIT_CELSIUS    0
#define AIRLOGGER_TEMPERATURE_UNIT_FAHRENHEIT 1
#define AIRLOGGER_TEMPERATURE_UNIT_KELVIN     2 

// Sampling Rate
#define AIRLOGGER_SAMPLE_100USEC 1
#define AIRLOGGER_SAMPLE_200USEC 2
#define AIRLOGGER_SAMPLE_500USEC 3
#define AIRLOGGER_SAMPLE_1MSEC   4
#define AIRLOGGER_SAMPLE_2MSEC   5
#define AIRLOGGER_SAMPLE_5MSEC   6
#define AIRLOGGER_SAMPLE_10MSEC  7
#define AIRLOGGER_SAMPLE_20MSEC  8
#define AIRLOGGER_SAMPLE_50MSEC  9
#define AIRLOGGER_SAMPLE_100MSEC 10
#define AIRLOGGER_SAMPLE_200MSEC 11
#define AIRLOGGER_SAMPLE_500MSEC 12
#define AIRLOGGER_SAMPLE_1SEC    13
#define AIRLOGGER_SAMPLE_2SEC    14
#define AIRLOGGER_SAMPLE_10SEC   15
#define AIRLOGGER_SAMPLE_1MIN    16
#define AIRLOGGER_SAMPLE_5MIN    17
#define AIRLOGGER_SAMPLE_10MIN   18

// Sensor Type
#define AIRLOGGER_SENSOR_NO_USE               0
#define AIRLOGGER_SENSOR_THERMOCOUPLE_K       1
#define AIRLOGGER_SENSOR_THERMOCOUPLE_T       2
#define AIRLOGGER_SENSOR_THERMOCOUPLE_J       3
#define AIRLOGGER_SENSOR_VOLTAGE              5 
#define AIRLOGGER_SENSOR_STRAIN               6

// Voltage Range
#define AIRLOGGER_VOLTAGE_RANGE_NO_USE	  0
#define AIRLOGGER_VOLTAGE_RANGE_100MV     1
#define AIRLOGGER_VOLTAGE_RANGE_1V		  3
#define AIRLOGGER_VOLTAGE_RANGE_12V		  5

// Strain Range
#define AIRLOGGER_STRAIN_RANGE_NO_USE	 0
#define AIRLOGGER_STRAIN_RANGE_20000UST	 1
#define AIRLOGGER_STRAIN_RANGE_10000UST	 2
#define AIRLOGGER_STRAIN_RANGE_5000UST	 3
#define AIRLOGGER_STRAIN_RANGE_2000UST	 4

// Battery Level
#define AIRLOGGER_BATTERY_LEVEL_UNKNOWN   0
#define AIRLOGGER_BATTERY_LEVEL_NORMAL    1
#define AIRLOGGER_BATTERY_LEVEL_ATTENTION 2
#define AIRLOGGER_BATTERY_LEVEL_WARNING   3

// Radio Wave
#define AIRLOGGER_RADIO_WAVE_FINE   0
#define AIRLOGGER_RADIO_WAVE_NORMAL 1
#define AIRLOGGER_RADIO_WAVE_BAD    2

// Unit Type // new
#define AIRLOGGER_UNIT_TYPE_WM2000TA		0
#define AIRLOGGER_UNIT_TYPE_WM2000TB		1
#define AIRLOGGER_UNIT_TYPE_WM2000SB		2
#define AIRLOGGER_UNIT_TYPE_WM2000SB_350	3
#define AIRLOGGER_UNIT_TYPE_WM2000SA		6
#define AIRLOGGER_UNIT_TYPE_WM2000SA_350	7


extern "C" {

AIRLOGGERAPI_API int WINAPI AirLogger_Initialize(void);
AIRLOGGERAPI_API int WINAPI AirLogger_SetTemperatureUnit(int unit);
AIRLOGGERAPI_API int WINAPI AirLogger_GetTemperatureUnit(int* unit);
AIRLOGGERAPI_API int WINAPI AirLogger_SetUnitSamplingRate(int unit, int rate);
AIRLOGGERAPI_API int WINAPI AirLogger_GetUnitSamplingRate(int unit, int* pRate);
AIRLOGGERAPI_API int WINAPI AirLogger_SetUnitSensorType(int unitNumber, int channelNumber, int type);
AIRLOGGERAPI_API int WINAPI AirLogger_GetUnitSensorType(int unitNumber, int channelNumber, int* pType);
AIRLOGGERAPI_API int WINAPI AirLogger_SetVoltageRange(int unitNumber, int channelNumber, int range);
AIRLOGGERAPI_API int WINAPI AirLogger_GetVoltageRange(int unit, int channelNumber, int* pRange);
AIRLOGGERAPI_API int WINAPI AirLogger_SetStrainRange(int unitNumber, int channelNumber, int range);
AIRLOGGERAPI_API int WINAPI AirLogger_GetStrainRange(int unit, int channelNumber, int* pRange);
typedef void (CALLBACK *AirLogger_WM2000_Callback)(int unitNumber, int channelNumber, unsigned long long sequenceNumber, int batteryLevel, int radioWave, BOOL isLost, BOOL isDisconnection, int error_flag, int data_size, double *data);
AIRLOGGERAPI_API int WINAPI AirLogger_WM2000_StartMeasurement(AirLogger_WM2000_Callback pFunc);
AIRLOGGERAPI_API int WINAPI AirLogger_GetState(void);
AIRLOGGERAPI_API int WINAPI AirLogger_StopMeasurement(void);
AIRLOGGERAPI_API int WINAPI AirLogger_StartLoadingLostData(AirLogger_WM2000_Callback pFunc, int unitNumber);
AIRLOGGERAPI_API int WINAPI AirLogger_StopLoadingLostData(void);
AIRLOGGERAPI_API int WINAPI AirLogger_Finalize(void);
typedef void (CALLBACK *AirLogger_SendMeasurementConditionCallback)(int unitNumber);
AIRLOGGERAPI_API int WINAPI AirLogger_SendMeasurementCondition(AirLogger_SendMeasurementConditionCallback pFunc, int waitTime);
AIRLOGGERAPI_API int WINAPI AirLogger_GetNoizeLevel(int ch, int* level);
AIRLOGGERAPI_API int WINAPI AirLogger_SetAutoFrequencyNumber(int changefrequencyNumber, int *FailCnt, int *unitNumber);
AIRLOGGERAPI_API int WINAPI AirLogger_CheckDisconnect(int *unitNumber, int *isConnect, int *size);
AIRLOGGERAPI_API int WINAPI AirLogger_ZeroPointAdjustment(int *unitNumber, BOOL *isInit, int *size);
AIRLOGGERAPI_API int WINAPI AirLogger_SetMeasurementStandby(void);
AIRLOGGERAPI_API int WINAPI AirLogger_StopAllUnit(void);
typedef void (CALLBACK *AirLogger_HighSpeedConnectionCallback)(int unitNumber);
AIRLOGGERAPI_API int WINAPI AirLogger_EnableHighSpeedConnection(AirLogger_HighSpeedConnectionCallback pFunc, int waitTime);
AIRLOGGERAPI_API int WINAPI AirLogger_DisableHighSpeedConnection(AirLogger_HighSpeedConnectionCallback pFunc, int waitTime);
AIRLOGGERAPI_API int WINAPI AirLogger_GetSystemUnitCount(int *count);
AIRLOGGERAPI_API int WINAPI AirLogger_GetSystemUnitInfomation(int *unitNumber, int *unitType, char **serialNumber);
AIRLOGGERAPI_API int WINAPI AirLogger_WarmupSensorUnit(int unitNumber, BOOL OnOff);
AIRLOGGERAPI_API int WINAPI AirLogger_SetDataReceiverFrequencyNumber(int frequencyNumber);
AIRLOGGERAPI_API int WINAPI AirLogger_GetDataReceiverFrequencyNumber(int* frequencyNumber);
AIRLOGGERAPI_API int WINAPI AirLogger_CancelStop(void);
typedef void (CALLBACK *AirLogger_StopUnitCallback)(int unitNumber);
AIRLOGGERAPI_API int WINAPI AirLogger_SetStopUnitCallback(AirLogger_StopUnitCallback pFunc);
}


#endif // AIRLOGGERAPI_H
