#include <Windows.h>
#include "AirLoggerAPI.h"
#include <iostream>
#include <string>
using namespace std;

void _stdcall callback(int unitNo, int channelNo, unsigned long long sequenceNumber, int batteryLevel, int radioWave, BOOL isLost, BOOL isDisconnection, int error_flag, int data_size, double *Data) {

	cout << endl;
	cout << "UNIT No: " << unitNo << endl;
	cout << "CH NO: " << channelNo << endl;
	cout << "Seq No: " << sequenceNumber << endl;
	cout << "BATTERY:" << batteryLevel << endl;
	cout << "RADIO WAVE:" << radioWave << endl;
	cout << "LOST:" << isLost << endl;
	cout << "DISCONNECT:" << isDisconnection << endl;
	cout << "ERROR:" << error_flag << endl;
	cout << "DATA COUNT:" << data_size << endl;
	for (int i = 0; i < data_size; i++) {
		// {TvvO50mSecTvOԂł̂ŁAsequenceNo@+500ɂȂ܂
		unsigned long long currentSequenceNumber = sequenceNumber + i * 500;
		cout << "UNIT" << unitNo << "  Seq No: " << currentSequenceNumber << "  CH" << channelNo << " DATA " << Data[i] << endl;
	}
	cout << flush;
}
void _stdcall ConditionCallback(int unitNo) {
	if (unitNo == -1) {
		cout << "Setting Condition ERROR" << endl;
		cout << flush;
	}
	else if (unitNo == 0) {
		cout << "Setting Condition OK" << endl;
		cout << flush;
	}
}

void _stdcall WLancallback(int unitNo) {
	if (unitNo == -1) {
		cout << "Setting HighSpeedConnection ERROR" << endl;
		cout << flush;
	}
	else if (unitNo == 0) {
		cout << "Setting HighSpeedConnection OK" << endl;
		cout << flush;
	}
}

void checkError(string functionName, int returnCode) {
	switch (returnCode) {
	case AIRLOGGER_SUCCESS:
		return;
	case AIRLOGGER_INVALID_PARAMETER:
		cout << functionName + ": AIRLOGGER_INVALID_PARAMETER" << endl;
		break;
	case AIRLOGGER_INVALID_STATE:
		cout << functionName + ": AIRLOGGER_INVALID_STATE" << endl;
		break;
	case AIRLOGGER_COMMUNICATION_ERROR:
		cout << functionName + ": AIRLOGGER_INVALID_STATE" << endl;
		break;
	}
	exit(returnCode);
}
void _stdcall StopUnitCallback(int unitNo) {
	if (unitNo == -1) {
		cout << "Stop Unit ERROR" << endl;
		cout << flush;
	}
	else if (unitNo) {
		cout << "Stop Unit OK" << endl;
		cout << flush;
	}
}

int main()
{
	checkError("AirLogger_Initialize", AirLogger_Initialize());
	checkError("AirLogger_SetTemperatureUnit",
		AirLogger_SetTemperatureUnit(AIRLOGGER_TEMPERATURE_UNIT_CELSIUS));

	// UNIT1̏ݒ(WM2000TA)
	checkError("AirLogger_SetUnitSensorType", AirLogger_SetUnitSensorType(1, 1, AIRLOGGER_SENSOR_THERMOCOUPLE_K));
	checkError("AirLogger_SetUnitSensorType", AirLogger_SetUnitSensorType(1, 2, AIRLOGGER_SENSOR_THERMOCOUPLE_K));
	checkError("AirLogger_SetUnitSamplingRate", AirLogger_SetUnitSamplingRate(1, AIRLOGGER_SAMPLE_1SEC));

	// UNUT2̏ݒ(WM2000TB)
	for (int channel = 1; channel <= 7; channel++) {
		checkError("AirLogger_SetUnitSensorType", AirLogger_SetUnitSensorType(2, channel, AIRLOGGER_SENSOR_THERMOCOUPLE_K));
	}
	checkError("AirLogger_SetUnitSamplingRate", AirLogger_SetUnitSamplingRate(2, AIRLOGGER_SAMPLE_1SEC));

	// UNIT3̏ݒ(WM2000SA)
	checkError("AirLogger_SetUnitSensorType", AirLogger_SetUnitSensorType(3, 1, AIRLOGGER_SENSOR_STRAIN));
	checkError("AirLogger_SetUnitSamplingRate", AirLogger_SetUnitSamplingRate(3, AIRLOGGER_SAMPLE_100MSEC));

	// UNIT4̏ݒ(WM2000SB)
	for (int channel = 1; channel <= 3; channel++) {
		checkError("AirLogger_SetSensorType", AirLogger_SetUnitSensorType(4, channel, AIRLOGGER_SENSOR_STRAIN));

		checkError("AirLogger_SetStrainRange", AirLogger_SetStrainRange(4, channel, AIRLOGGER_STRAIN_RANGE_2000UST));
	}
	checkError("AirLogger_SetSamplingRate", AirLogger_SetUnitSamplingRate(4, AIRLOGGER_SAMPLE_50MSEC));

	// ݒ𑪒胆jbgɐݒ
	checkError("AirLogger_SendMeasurementCondition", AirLogger_SendMeasurementCondition(ConditionCallback, 60));

	// f[^V[o̐ݒ(WM2000SBȊO͕svj
	checkError("AirLogger_EnableHighSpeedConnection", AirLogger_EnableHighSpeedConnection(WLancallback, 60));

	int* unitNumber = new int[100];
	int* result = new int[100];
	int* size = new int[1];

	// UNIT3/UNIT4 (WM2000SA/WM2000SB̃[_j
	checkError("AirLogger_ZeroPointAdjustment",
		AirLogger_ZeroPointAdjustment(unitNumber, result, size));

	// 菀
	checkError("AirLogger_SetMeasurementStandby", AirLogger_SetMeasurementStandby());

	// Jn
	checkError("AirLogger_WM2000_StartMeasurement", AirLogger_WM2000_StartMeasurement(callback));
	Sleep(10000);
	// I
	checkError("AirLogger_SetStopUnitCallback", AirLogger_SetStopUnitCallback(StopUnitCallback));
	checkError("AirLogger_StopMeasurement", AirLogger_StopMeasurement());

	// LOSTf[^̎擾
	// 胆jbgPCʐMjbg̋߂Ɉړ
	cout << "0<CR>͂Ă" << endl;
	int lost = getchar();

	for (int unit = 1; unit <= 4; unit++) {
		checkError("AirLogger_StartLoadingLostData", AirLogger_StartLoadingLostData(callback, unit));
	}

	checkError("AirLogger_Finalize", AirLogger_Finalize());
}
