VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Power Channel"
   ClientHeight    =   3210
   ClientLeft      =   2385
   ClientTop       =   2355
   ClientWidth     =   8475
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3210
   ScaleWidth      =   8475
   Begin VB.CommandButton Command1 
      Caption         =   "Power Monter (Zero Span )"
      Height          =   495
      Index           =   2
      Left            =   5040
      TabIndex        =   3
      Top             =   120
      Width           =   2235
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Total Power"
      Height          =   495
      Index           =   1
      Left            =   1980
      TabIndex        =   2
      Top             =   120
      Width           =   1515
   End
   Begin VB.TextBox txtRslt 
      BeginProperty Font 
         Name            =   "lr SVbN"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2235
      Left            =   360
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   1
      Top             =   780
      Width           =   7635
   End
   Begin VB.CommandButton Command1 
      Caption         =   "CH Power"
      Height          =   495
      Index           =   0
      Left            =   360
      TabIndex        =   0
      Top             =   120
      Width           =   1515
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Const MFREQ As Double = 2000000000#   'LAg
Const CHPOW_REF As Double = 0#        'POW Reference level
Const TOTPW_REF As Double = 0#        'Total Power Reference level
Const ZeroSP_REF As Double = 0#       'Zero Span Power Reference level
'If Level Offset is ON then,
'Const CHPOW_REF As Double = 30#        'POW Reference level
'Const TOTPW_REF As Double = 30#        'Total Power Reference level
'Const ZeroSP_REF As Double = 30#       'Zero Span Power Reference level
'


Private Sub Command1_Click(Index As Integer)
Select Case Index
Case 0      'CH Power
    MeasChPow MFREQ, CHPOW_REF            'ChPow

Case 1      'Total Power
    MeasTotpw MFREQ, TOTPW_REF            'TotPow

Case 2      'Zero Span Power
    MeasZeropw MFREQ, ZeroSP_REF          'Zero Span Mode
    
Case Else

End Select

End Sub

Sub MeasChPow(measF As Double, measRef As Double)
Dim Power As Double

    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
    
    txtRslt.SelText = vbCrLf & "CH Power Measurement..." & vbCrLf

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "PMEASAVG OFF")                  'AVG OFF
    Call ibwrt(ud, "SP 10e6HZ")                     'Span 10MHz
    Call ibwrt(ud, "RB 1MZ; VB 1MZ")                'RBW 1MHz, VBW 1MHz
    Call ibwrt(ud, "AS")                            'SWEEP AUTO or setup
    
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    'Call ibwrt(ud, "RO ON; RO 30 DB")               'Level Offset
    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level
    
    Call ibwrt(ud, "WLX " & Format(measF) & "HZ")   'Ch Center
    Call ibwrt(ud, "WDX " & Format(3840000#) & "HZ") 'Ch Span
    
    Call ibwrt(ud, "PWCHON")                        'Ch Pow ON
        
    Call GetChPower(Power)                          'Measurement
    
    'ʕ\
    txtRslt.SelText = "CH Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
    
    Call ibwrt(ud, "PMEASOFF")                      'POW OFF

    Call ibonl(ud, 0)                               'GPIB device 
    Call ibonl(0, 0)                                'GPIB board 

End Sub

Sub GetChPower(Power As Double)
Dim sBuff As String * 50

    If 0 Then                                       'AverageȂꍇ
        Call ibwrt(ud, "TS")                            'Sweep once
    Else                                            'Averageꍇ
        Call ibwrt(ud, "PMEASAVGONCE ONCE")             'AVG single
        Call ibwrt(ud, "PWCHTM 10")                     'CH Power AVG 10 times
        Call ibwrt(ud, "PMEASAVG ON")                   'AVG start
        Call ibwrt(ud, "CONTS")                         'Sweep continue
        WaitMeasEnd                                     'Wait AVG end
    End If
    
    Call ibwrt(ud, "PWCH?")                         'GET POW data
    sBuff = ""
    Call ibrd(ud, sBuff)                            'GET POW data
    Power = sBuff

End Sub

Sub MeasTotpw(measF As Double, measRef As Double)
Dim Power As Double

    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
    
    txtRslt.SelText = vbCrLf & "Total Power Measurement..." & vbCrLf

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "PMEASAVG OFF")                  'AVG OFF
    Call ibwrt(ud, "SP 10e6HZ")                     'Span 10MHz
    Call ibwrt(ud, "RB 1MZ; VB 1MZ")                'RBW 1MHz, VBW 1MHz
    Call ibwrt(ud, "AS")                            'SWEEP AUTO or setup
    
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    'Call ibwrt(ud, "RO ON; RO 30 DB")               'Level Offset
    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level

    Call ibwrt(ud, "PWTOTALON")                     'Ch Pow ON
    
    
    Call GetTotPower(Power)                         'Measurement
    
    'ʕ\
    txtRslt.SelText = "Total Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
    
    Call ibwrt(ud, "PMEASOFF")                      'POW OFF

    Call ibonl(ud, 0)                               'GPIB device 
    Call ibonl(0, 0)                                'GPIB board 

End Sub

Sub GetTotPower(Power As Double)
Dim sBuff As String * 50
    
    If 0 Then                                       'AverageȂꍇ
        Call ibwrt(ud, "TS")                            'Sweep once
    Else                                            'Averageꍇ
        Call ibwrt(ud, "PMEASAVGONCE ONCE")             'AVG single
        Call ibwrt(ud, "PWTOTALTM 10")                  'TOTAL POW/ AVG 10 times
        Call ibwrt(ud, "PMEASAVG ON")                   'AVG start
        Call ibwrt(ud, "CONTS")                         'Sweep continue
        WaitMeasEnd                                     'Wait AVG end
    End If
    
    Call ibwrt(ud, "PWTOTAL?")                      'GET POW data
    sBuff = ""
    Call ibrd(ud, sBuff)                            'GET POW data
    Power = sBuff

End Sub

Sub MeasZeropw(measF As Double, measRef As Double)
Dim Power As Double

    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
    
    txtRslt.SelText = vbCrLf & "Zero Span Mode Power Measurement..."

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "PMEASAVG OFF")                  'AVG OFF
    Call ibwrt(ud, "SP 0HZ")                        'Span Zero
    Call ibwrt(ud, "RB 3MZ; VB 3MZ")                'RBW 1MHz, VBW 1MHz
    Call ibwrt(ud, "SW 100MS")                      'SWEEP Time 100ms or ...
                                                    'SW 20ms and AVG mode ON...
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    'Call ibwrt(ud, "RO ON; RO 30 DB")               'Level Offset
    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level

    Call ibwrt(ud, "PWAVGON")                       'Ch Pow ON
    
    'txtRslt.SelText = "(Average mode ON)..." & vbCrLf
    txtRslt.SelText = "(Average mode OFF)..." & vbCrLf
    
    Call GetZeroPower(Power)                         'Measurement
    
    'ʕ\
    txtRslt.SelText = "Total Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
    
    Call ibwrt(ud, "PMEASOFF")                      'POW OFF
    Call ibwrt(ud, "CONTS")                         'Sweep continue for AVG mode OFF

    Call ibonl(ud, 0)                               'GPIB device 
    Call ibonl(0, 0)                                'GPIB board 

End Sub

Sub GetZeroPower(Power As Double)
Dim sBuff As String * 50
    
    If 1 Then                                       'AverageȂꍇ = 1
        Call ibwrt(ud, "TS")                            'Sweep once
    Else                                            'Averageꍇ
        Call ibwrt(ud, "PMEASAVGONCE ONCE")             'AVG single
        Call ibwrt(ud, "PWAVGTM 10")                    'AVG POW/ AVG 10 times
        Call ibwrt(ud, "PMEASAVG ON")                   'AVG start
        Call ibwrt(ud, "CONTS")                         'Sweep continue
        WaitMeasEnd                                     'Wait AVG end
    End If
    
    Call ibwrt(ud, "PWAVG?")                        'GET AVG data
    sBuff = ""
    Call ibrd(ud, sBuff)                            'GET AVG data
    Power = sBuff

End Sub

Private Sub Form_Load()
    txtRslt.Text = ""

End Sub
