Attribute VB_Name = "MdlGraph"
Option Explicit

Const GRAPH_Y_POSI_OFFSET As Single = 0.8

Public Const COLOR_DARKSLATEGRAY As Long = 5197615  ' RGB(&H2F, &H4F, &H4F)
Public Const COLOR_GRAY As Long = 8421504           ' RGB(&H80, &H80, &H80)
Public Const COLOR_GRID_LOGMAG As Long = COLOR_DARKSLATEGRAY
Public Const COLOR_BOLD_GRID_LOGMAG As Long = COLOR_GRAY
Public Const COLOR_WAVE_LOGMAG As Long = vbYellow
Public Const COLOR_REFL_LOGMAG As Long = COLOR_WAVE_LOGMAG

'Scale information
Type Scale_t
    ref As Single                   'REF VALUE
    div As Single                   '/DIV
    pos As Single                   'REF POSITION
End Type

Public Mscl As Scale_t              'scale


'************************************************************************
' Auto Scale Button
'         ByRef mx As Double   : Max
'         ByRef mn As Double   : Min
'         ByRef scl As Scale_t : Scale
'************************************************************************
Sub auto_scale(ByRef mx As Double, ByRef mn As Double, ByRef scl As Scale_t)
    Dim div As Double
    Dim divs As String
    Dim head As String
    Dim rfv As Double

    div = (mx - mn) / 9
    If div < 0.001 Then '=== Does not perform scaling when value is less than 0.001 ===
        div = 0.001
    Else
        div = div * 1000 '<-- Multiply the value by 1000 temporarily.
        divs = CStr(div)
        If CDbl(Mid(divs, 2)) > 0 Then 'When the second and subsequent digits are other than 0.
            divs = CStr(CDbl(divs) - CDbl(Mid(divs, 2))) 'Clear the second and subsequent digits from the beginning to 0.
            divs = (CDbl(Mid(divs, 1, 1)) + 1) & Mid(divs, 2) 'Round-up the first digit.
        End If
        head = Mid(divs, 1, 1) 'Take out the first character.
        If CDbl(head) > 5 Then '--- Convert the value to 1/2/5 step. ---
            head = "10" '        V
        ElseIf CDbl(head) > 2 Then  '        V
            head = "5" '        V
        ElseIf CDbl(head) > 1 Then  '        V
            head = "2" '        V
        End If '        V
        divs = head & Mid(divs, 2)
        div = CSng(divs) / 1000 '<-- Clear the multiplication by 1000.
    End If
    scl.div = div
    rfv = CSng(CLng((mx + mn) / 2 / div)) * div
    scl.ref = rfv + ((scl.pos - 50) * div) / 10

End Sub

'***********************************************************************************
' Grid
'         ByRef ViewX As Single   : X
'         ByRef ViewY As Single   : Y
'         ByRef VYoff As Single   : Offset Y
'         ByVal Color1 As Long    : color 1
'         ByVal Color2 As Long    : color 2
'***********************************************************************************
Sub grid_display(ByRef pic As PictureBox, ByVal ViewX As Single, ByVal ViewY As Single, _
                ByVal VYoff As Single, ByVal points As Long, ByVal Color1 As Long, ByVal Color2 As Long)
    Dim i As Integer
    Dim x1 As Single
    Dim y1 As Single
    Dim x2 As Single
    Dim y2 As Single
    
    pic.DrawStyle = 0  'Solid line specification
    '
    '----------------------------------
    ' Grid display
    '----------------------------------
    For i = 1 To 9
        If i <> 5 And i <> 10 Then
            pic.PSet (ViewX, ViewY * (i + VYoff))
            pic.Line -(ViewX * 101, ViewY * (i + VYoff)), Color1
            pic.PSet (ViewX * (i * 10 + 1), ViewY * VYoff)
            pic.Line -(ViewX * (i * 10 + 1), ViewY * (10 + VYoff)), Color1
        End If
    Next i

    For i = 0 To 10 Step 5
        pic.PSet (ViewX, ViewY * (i + VYoff))
        pic.Line -(ViewX * 101, ViewY * (i + VYoff)), Color2
        pic.PSet (ViewX * (i * 10 + 1), ViewY * VYoff)
        pic.Line -(ViewX * (i * 10 + 1), ViewY * (10 + VYoff)), Color2
    Next i

    pic.Line -(ViewX * 101, ViewY * 10), Color2  ' Because the end point is not displayed.

End Sub

'***********************************************************************************
' reference marker display
'    Sub ref_mkr_display()
'         ByRef ViewX As Single   : X
'         ByRef ViewY As Single   : Y
'         ByRef VYoff As Single   : Offset Y
'         ByRef Scale As Scale_t  : scale
'         ByVal Color As Long     : marker color
'***********************************************************************************
Sub ref_mkr_display(ByRef pic As PictureBox, ByVal ViewX As Single, ByVal ViewY As Single, ByVal VYoff As Single, _
                    ByRef scl As Scale_t, ByVal Color As Long)
    Dim yy As Single
    Dim x1 As Single
    Dim y1 As Single
    Dim x2 As Single
    Dim y2 As Single

    '----------------------------------
    ' Reference mark  display
    '----------------------------------
    yy = ViewY * (10 + VYoff - scl.pos / 10)
    pic.PSet (ViewX * 101, yy)
    pic.Line -(ViewX * 103, yy - ViewY * 0.15), Color
    pic.Line -(ViewX * 103, yy + ViewY * 0.15), Color
    pic.Line -(ViewX * 101, yy), Color
End Sub


'***********************************************************************************
' scale value range check
'    Function SclLim() As Single
'         ByRef mx As Single : max area
'         ByRef mn As Single : min area
'         ByRef vy As Single : Y offset
'         ByRef dy As Single : Y ratio
'         ByRef dt As Single : measurement value
'
'    Return value : display position
'***********************************************************************************
Private Function SclLim(ByVal mx As Single, ByVal mn As Single, ByVal vy As Single, _
                        ByVal dy As Single, ByVal dt As Single) As Single
    Dim hh As Single
    Dim ym As Single
    Dim yn As Single

    '' Add a few dots to the upper and lower scale limits.
    hh = dy * (mx - mn)
    ym = hh * (-0.01)
    yn = hh * 1.01
    SclLim = dy * (mx - dt)
    If ym > SclLim Then
        SclLim = ym
    ElseIf SclLim > yn Then
        SclLim = yn
    End If
    SclLim = vy + SclLim

End Function

'***********************************************************************************
' Logmag wave display
'    Sub waveform_display()
'         ByRef ViewX As Single   : X
'         ByRef ViewY As Single   : Y
'         ByRef VYoff As Single   : Offset Y
'         ByRef Scale As Scale_t  : Scale
'         ByRef points As Integer : data points
'         ByRef Color As Long     : wave color
'         ByRef data() As Single  : wave data (trace data)
'***********************************************************************************
Sub waveform_display(ByVal pic As PictureBox, ByVal ViewX As Single, ByVal ViewY As Single, ByVal VYoff As Single, _
         ByVal DeltX As Single, ByRef scl As Scale_t, ByVal points As Integer, ByVal Color As Long, _
         ByRef Data() As Single)
    Dim Grefv, Gsdiv, Grefp, StepSdiv As Single
    Dim ss As Single
    Dim Gsmax, Gsmin As Single
    Dim DeltY As Single
    Dim x1, y1, x2, y2 As Single
    Dim x1_pre, y1_pre, x2_pre, y2_pre As Single
    Dim i As Integer
    Dim po As Long
    Dim Ydata1 As Single
    
    On Error GoTo ErrLogmagOverflow

    '----------------------------------
    ' LOGMAG waveform
    '----------------------------------
    Grefv = scl.ref
    Gsdiv = scl.div
    Grefp = scl.pos
    StepSdiv = Gsdiv / 10
    ss = Abs(100 - Grefp)
    Gsmax = Grefv + (ss * StepSdiv)
    Gsmin = Grefv - (Abs(100 - ss) * StepSdiv)

    'Calculating 
    ss = Gsmax - Gsmin
    If ss = 0 Then ss = Gsmin
    DeltY = (ViewY * 10) / ss
    '
    Ydata1 = SclLim(Gsmax, Gsmin, ViewY * VYoff, DeltY, Data(0))
    pic.PSet (ViewX, Ydata1)
    i = 0
    For po = 0 To points
        Ydata1 = SclLim(Gsmax, Gsmin, ViewY * VYoff, DeltY, Data(i))
        pic.Line -(DeltX * po + ViewX, Ydata1), Color
        i = i + 1
    Next po
    
ErrLogmagEnd:
    On Error GoTo 0
    Exit Sub

ErrLogmagOverflow:
    MsgBox "Error Data Overflow" + vbCrLf + vbCrLf, vbOKOnly Or vbCritical
    GoTo ErrLogmagEnd

End Sub

'***********************************************************************************
' box
'    Sub box_x_display()
'     ByVal g As Graphics : graphic object
'         ByRef points As Integer : data points
'         ByRef p1 As Integer : Box(x1, y) markler display point
'         ByRef p2 As Integer : Box(x2, y) markler display point
'***********************************************************************************
Sub box_x_display(ByRef pic As PictureBox, ByVal points As Integer, ByRef scl As Scale_t, _
                    ByVal p1 As Integer, ByVal p2 As Integer, ByVal y As Single, Color As Long)
    Dim Grefv, Gsdiv, Grefp, StepSdiv As Single
    Dim ss As Single
    Dim Gsmax, Gsmin As Single
    Dim xx As Single
    Dim yy As Single
    Dim ViewY, ViewX, VYoff As Single
    Dim DeltX As Single
    Dim x1, x2 As Single
    Dim DeltY As Single
    
    Grefv = scl.ref
    Gsdiv = scl.div
    Grefp = scl.pos
    StepSdiv = Gsdiv / 10
    ss = Abs(100 - Grefp)
    Gsmax = Grefv + (ss * StepSdiv)
    Gsmin = Grefv - (Abs(100 - ss) * StepSdiv)
    ss = Gsmax - Gsmin
    If ss = 0 Then ss = Gsmin

    'Calculates size of scale frame
    ViewX = pic.ScaleWidth / 104
    ViewY = pic.ScaleHeight / 11
    VYoff = GRAPH_Y_POSI_OFFSET
    DeltX = (ViewX * 100) / points
    DeltY = (ViewY * 10) / ss
    
    x1 = DeltX * p1 + ViewX
    x2 = DeltX * p2 + ViewX
    
    yy = SclLim(Gsmax, Gsmin, ViewY * VYoff, DeltY, y)
    pic.PSet (x1, yy)
    pic.Line -(x2, yy), Color

End Sub



'***********************************************************************************
' box
'    Sub box_y_display()
'     ByVal g As Graphics : graphic object
'         ByRef points As Integer : data points
'         ByRef p1 As Integer : Box(x1, y) markler display point
'         ByRef p2 As Integer : Box(x2, y) markler display point
'***********************************************************************************
Sub box_y_display(ByRef pic As PictureBox, ByVal points As Integer, ByVal p1 As Integer, ByVal p2 As Integer, Color As Long)
    Dim xx As Single
    Dim ViewY, ViewX, VYoff As Single
    Dim DeltX As Single
    Dim x1, x2 As Single

    'Calculates size of scale frame
    ViewX = pic.ScaleWidth / 104
    ViewY = pic.ScaleHeight / 11
    VYoff = GRAPH_Y_POSI_OFFSET
    DeltX = (ViewX * 100) / points
    
    x1 = DeltX * p1 + ViewX
    pic.PSet (x1, ViewY * VYoff)
    pic.Line -(x1, ViewY * (10 + VYoff)), Color

    x2 = DeltX * p2 + ViewX
    pic.PSet (x2, ViewY * VYoff)
    pic.Line -(x2, ViewY * (10 + VYoff)), Color
    
End Sub


'***********************************************************************************
' Vertical marker display (Logmag & Phase)
'    Sub v_mkr_display()
'    Argument ByVal g As Graphics : Object of the graph display
'         ByRef ViewX As Single : Display area (X)
'         ByRef ViewY As Single : Display area (Y)
'         ByRef VYoff As Single : Offset in Y direction
'         ByRef points As Integer : Number of measurement points
'         ByRef mp As Integer : Marker display position point
'***********************************************************************************
Sub v_mkr_display(ByRef pic As PictureBox, ByVal ViewX As Single, ByVal ViewY As Single, ByVal VYoff As Single, _
                  ByVal DeltX As Single, ByRef Data() As Single, ByRef scl As Scale_t, ByVal points As Integer, ByVal mp As Integer)

    Dim Grefv, Gsdiv, Grefp, StepSdiv As Single
    Dim ss As Single
    Dim Gsmax, Gsmin, dt As Single
    Dim DeltY As Single
    Dim xx As Single
    Dim yy As Single
    Dim Color As Long
    Dim k As Integer
    Dim StrMeasData As String
    Dim Y_line As Single
    Dim line_cnt As Integer

    Grefv = scl.ref
    Gsdiv = scl.div
    Grefp = scl.pos
    StepSdiv = Gsdiv / 10
    ss = Abs(100 - Grefp)
    Gsmax = Grefv + (ss * StepSdiv)
    Gsmin = Grefv - (Abs(100 - ss) * StepSdiv)

    'Calculating 
    ss = Gsmax - Gsmin
    If ss = 0 Then ss = Gsmin
    DeltY = (ViewY * 10) / ss
    '
    Y_line = 0 '150    ' 1 Line Offset
    line_cnt = 0
    
    Color = vbWhite 'vbRed
    If mp >= 0 Then
        dt = Data(mp)
        xx = DeltX * mp + ViewX
        yy = SclLim(Gsmax, Gsmin, ViewY * VYoff, DeltY, dt)
        pic.PSet (xx, yy)
        pic.Line (xx, yy)-(xx, yy - 200), Color
        pic.Line (xx, yy)-(xx - 40, yy - 100), Color
        pic.Line (xx, yy)-(xx + 40, yy - 100), Color
        Call frmMain.PicBoxTextDisp(xx - 50, yy - 380, "X", 10, Color) 'Marker No. display
        
        Call frmMain.make_mkr_list(mp, StrMeasData)
        Call frmMain.PicBoxTextDisp(100, Y_line * line_cnt, StrMeasData, 8, vbWhite)
    End If
    
End Sub

'**********************************************
' Wave display
'   ByRef buf1() As Single : LogMag data
'   ByRef pt As Integer : data points
'   ByRef s1 As Scale_t : scale
'**********************************************
Sub draw_wave(ByRef pic As PictureBox, _
                ByRef buf1() As Single, _
                ByRef pt As Long, _
                ByRef s1 As Scale_t, _
                ByVal mp As Long)
    Dim ViewY, ViewX, VYoff As Single
    Dim points As Integer
    Dim DeltX As Single

    points = pt - 1

    'Calculates size of scale frame
    ViewX = pic.ScaleWidth / 104
    ViewY = (pic.ScaleHeight) / 11
    VYoff = GRAPH_Y_POSI_OFFSET
    DeltX = (ViewX * 100) / points

    pic.Cls
    '----------------------------------
    ' Grid display
    '----------------------------------
    Call grid_display(pic, ViewX, ViewY, VYoff, points, COLOR_GRID_LOGMAG, COLOR_BOLD_GRID_LOGMAG)
    '----------------------------------
    'Reference mark  display
    '----------------------------------
    Call ref_mkr_display(pic, ViewX, ViewY, VYoff, s1, COLOR_REFL_LOGMAG)   ' Lognmag
    '----------------------------------
    ' LOGMAG waveform
    '----------------------------------
    Call waveform_display(pic, ViewX, ViewY, VYoff, DeltX, s1, points, COLOR_WAVE_LOGMAG, buf1)
    
    Call box_y_display(pic, pt, LimitRFID.LwFreqP, LimitRFID.UpFreqP, vbRed)

    Call box_x_display(pic, pt, s1, LimitRFID.LwFreqP, LimitRFID.UpFreqP, LimitRFID.UpLevel, vbRed)
    Call box_x_display(pic, pt, s1, LimitRFID.LwFreqP, LimitRFID.UpFreqP, LimitRFID.LwLevel, vbRed)
    
    If mp >= 0 Then
        Call v_mkr_display(pic, ViewX, ViewY, VYoff, DeltX, buf1, s1, pt, mp)
    End If
End Sub

