Attribute VB_Name = "MdlVariable"
Option Explicit

Type RFID_Limit
    UpFreqP As Integer          'Freq Upper point
    LwFreqP As Integer          'Freq Lower point
    UpFreq As Double            'Upper limit Freq.
    LwFreq As Double            'Lower limit Freq.
    UpLevel As Single           'Upper limit Level.
    LwLevel As Single           'Lower limit Level.
End Type

'max trace data points
Public Const MAX_MEAS_POINT As Long = 1600

'display format
Public Const fGHz$ = "#0.000000000#"                   ' Hz resolution
Public Const fMHz$ = "#0.000000#"                      ' Hz resolution
Public Const fkHz$ = "#0.000#"                         ' Hz resolution
Public Const fHz$ = "#000000#"                         ' Hz resolution

'unit
Public Const Unit_g As Single = 1000000000#             ' 1E+9  = Giga
Public Const Unit_mega As Single = 1000000#             ' 1E+6  = Mega
Public Const Unit_k As Single = 1000#                   ' 1E+3  = Kilo
Public Const Unit_s As Single = 1                       ' 1     = s
Public Const Unit_m As Single = 0.001                   ' 1E-3  = m
Public Const Unit_u As Single = 0.000001                ' 1E-6  = 
Public Const Unit_n As Single = 0.000000001             ' 1E-9  = n
Public Const Unit_p As Single = 0.000000000001          ' 1E-12 = p
Public Const Unit_f As Single = 0.000000000000001       ' 1E-15 = f

Public Const Multiple_g As Single = 0.000000001         ' 1E-9 = Giga
Public Const Multiple_mega As Single = 0.000001         ' 1E-6 = Mega
Public Const Multiple_k As Single = 0.001               ' 1E-3 = Kilo
Public Const Multiple_s As Single = 1                   ' 1 = s
Public Const Multiple_m As Single = 1000#               ' 1E+3
Public Const Multiple_mm As Single = 1000#              ' 1E+3
Public Const Multiple_u As Single = 1000000#            ' 1E+6
Public Const Multiple_n As Single = 1000000000#         ' 1E+9
Public Const Multiple_p As Single = 1000000000000#      ' 1E+12
Public Const Multiple_f As Single = 1E+15               ' 1E+15

'Cal
Public CorOn As Long                                    'Cal status
Public CorMeth As Long                                  'Cal Type
                                                        ' BIS_CAL_NORM = 0  : Normalize
                                                        ' BIS_CAL_TRANS = 1 : Transmission full calibration
                                                        ' BIS_CAL_1PORT = 2 : 1port Full Calibration
Public CorAcq(0 To 3) As Long                           ' 1port Full Calibration (0:OPNE, 1:SHORT, 2:LOAD, 3:Done)
Public cal1((MAX_MEAS_POINT + 1) * 2) As Single         ' Cal Data 1 (Real,Imag)
Public cal2((MAX_MEAS_POINT + 1) * 2) As Single         ' Cal Data 2 (Real,Imag)
Public cal3((MAX_MEAS_POINT + 1) * 2) As Single         ' Cal Data 3 (Real,Imag)

'NA
Public lngPID As Long               'ID
Public lngACh As Long               'Active CH
Public NA_ConnectProductName As String
Public NA_ProductName As String

'Measurment
Public lngTotP As Long              'points
Public ExitFlag As Integer          'Application endding flag
Public ContFlag As Integer          'Continuous sweep flag

'Trace No.
Public TrLgm As Long                'Logmag trace No.
Public TrCa1 As Long                'CAL1 trace No.
Public TrCa2 As Long                'CAL2 trace No.
Public TrCa3 As Long                'CAL3 trace No.

'Trace Data
Public BufLgm(1601) As Single       'Logmag
Public BufFrq(1601) As Double       'Frequency
Public ResonanceFreqP As Long       'Resonance Frequency point.

'Setting
Public BufSeg(0 To MAX_MEAS_POINT) As SourSeg   'Segment
Public SegCnt As Long               'Segment Sweep
Public SwpTime As Double            'Sweep time
Public SwpTAt As Long               'Sweep time Auto status (0:OFF, 1:ON).
Public IfRbw As Single              'RBW

'Limit
Public LimitRFID As RFID_Limit      'RFID Judge (limit)

