Attribute VB_Name = "MdlMain"
Option Explicit

Declare Sub Sleep Lib "KERNEL32.DLL" (ByVal dwMilliseconds As Long)

'*********
'  Judge
'*********
Private Function Limit_Chk(frq As Double, lvl As Double) As Boolean
    
    With LimitRFID
        If .UpFreq < frq Then Limit_Chk = False: Exit Function
        If .LwFreq > frq Then Limit_Chk = False: Exit Function
        If .UpLevel < lvl Then Limit_Chk = False: Exit Function
        If .LwLevel > lvl Then Limit_Chk = False: Exit Function
    End With
    
    Limit_Chk = True
End Function

'*******************************
' Sweep & Judge & wave display
'*******************************
Public Sub bna_test()
    Dim endP As Long
    Dim totlP As Long
    Dim lngErr As Long
    Dim lvl As Double
    Dim frq As Double
    Dim blnjudg As Boolean
    Dim stat As Long
    
    lngErr = BisInitImm(lngPID)                 'Start sweep
    lngErr = BisInitWai(lngPID)
    
    'CH1 Logmag trace data get.
    lngErr = QryTracData(lngPID, TrLgm, 0, lngTotP - 1, BufLgm(0))
    
    'Serach min data (Logmag trace)
    lngErr = QryFetcMin(lngPID, TrLgm, 0, lngTotP - 1, lvl, frq, ResonanceFreqP)
    
    blnjudg = Limit_Chk(frq, lvl)
    
    ' *** Judge ****
    If blnjudg = True Then
        frmMain.Label_Judgment.Caption = "PASS"
        frmMain.Label_Judgment.BackColor = vbBlue
    Else
        frmMain.Label_Judgment.Caption = "FAIL"
        frmMain.Label_Judgment.BackColor = vbRed
'        Call Beep
    End If
    
    ' *** Display wave ****
    Call draw_wave(frmMain.PictBox_Logmag, BufLgm(), lngTotP, Mscl, ResonanceFreqP)
    
End Sub

Private Sub Main()
    Dim lngErr As Long

    With frmMain
        .Show
        Do      ''--------------------- Main Loop
            If ExitFlag = 1 Then
                If lngPID Then
                    lngErr = BisClosePacket(lngPID)
                    lngPID = 0: ExitFlag = 0
                End If
            ElseIf ExitFlag = 2 Then
                If lngPID Then lngErr = BisClosePacket(lngPID)
                Exit Sub
            End If
            If .Option1(1).Value = True Then
                Do
                    Call bna_test
                    DoEvents
                Loop While (ContFlag)
            End If
            DoEvents
        Loop While (1)  ''------------- Main Loop
    End With
    
End Sub

