VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Spurious"
   ClientHeight    =   5325
   ClientLeft      =   2190
   ClientTop       =   2355
   ClientWidth     =   8865
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5325
   ScaleWidth      =   8865
   Begin VB.CommandButton Command4 
      Caption         =   "Point F Meas"
      Height          =   495
      Left            =   6120
      TabIndex        =   4
      Top             =   120
      Width           =   1575
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Harmonics"
      Height          =   495
      Left            =   4200
      TabIndex        =   3
      Top             =   120
      Width           =   1575
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Spurious Func"
      Height          =   495
      Left            =   2280
      TabIndex        =   2
      Top             =   120
      Width           =   1575
   End
   Begin VB.TextBox txtRslt 
      BeginProperty Font 
         Name            =   "Lucida Sans Unicode"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   4395
      Left            =   360
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   1
      Top             =   780
      Width           =   7995
   End
   Begin VB.CommandButton Command1 
      Caption         =   "PRESET"
      Height          =   495
      Left            =   360
      TabIndex        =   0
      Top             =   120
      Width           =   1515
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Const MFREQ As Double = 2000000000# 'LAg(gpj


Private Sub Command1_Click()


    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
    
    txtRslt.SelText = "Instrument Preset"
    
    Call ibwrt(ud, "RFC RFC1")          'RF1 for U3771/72
    Call ibwrt(ud, "IP")                'Instrument Preset
    Sleep 1500                          'Wait 1.5 sec
    
    txtRslt.SelText = "  ------------->>> End of Preset" & vbCrLf & vbCrLf
    
    '                                   'Measurement
    ' Call spurious_table
    ' Call harmonics
    ' Call spurious_fix
    
    Call ibonl(ud, 0)                   'GPIB device 
    Call ibonl(0, 0)                    'GPIB board 

End Sub


Sub spurious_table()

Dim buf As String * 100
Dim i, j, m, n, band As Integer


    txtRslt.SelText = "Spurious" & vbCrLf & vbCrLf
    
    Call ibwrt(ud, "SI")                ' sweep single mode
    
    ibwrt ud, "SPRTBL 0"
    ibwrt ud, "SPRFDEL"                 'Table clear
    ibwrt ud, "SPRFIN 30MZ, 750MZ, 1MZ, 1MZ, AUTO, 20DB, AUTO, OFF, -13DB"
    ibwrt ud, "SPRFIN 750MZ, 2.1GZ, 1MZ, 1MZ, AUTO, 20DB, AUTO, OFF, -13DB"
    ibwrt ud, "SPRFIN 2GZ, 3GZ, 1MZ, 1MZ, AUTO, 20DB, AUTO, OFF, -13DB"
    band = 3
    
    
    '-------------------- Condition Setup (One Time) -------------------

    Call ibwrt(ud, "DY 0.1")                        'Peak search sensitivity
    Call ibwrt(ud, "DET POS")
    Call ibwrt(ud, "RO ON; RO 0 DB")                'Level Offset
    
    
    ibwrt ud, "SPURI ON"                            'Measure Spurious
    
    '--------------------- Measurement ---------------------------------
    
    ibwrt ud, "CONTS"                   ' continuous sweep
    
    For i = 1 To band
       WaitSweepEnd                     'Measurement
    Next i
    
    Call ibwrt(ud, "SI")                'sweep single mode
    
    ibwrt ud, "SPURI?"
    
    buf = ""
    ibrd ud, buf                         ' Table
    txtRslt.SelText = buf & vbCrLf
    m = buf
    
    For i = 1 To m                       ' Table number
    
       buf = ""
       ibrd ud, buf
       txtRslt.SelText = buf & vbCrLf    ' Spurious nember
       n = buf
    
       For j = 1 To n                    ' Spurious
           buf = ""
           ibrd ud, buf
           txtRslt.SelText = buf & vbCrLf
       Next j
    
    Next i
    
    ibwrt ud, "SPURI OFF"               ' End of Measure Spurious
    ibwrt ud, "CONTS"                   ' continuous sweep


End Sub


Sub harmonics()

Dim buf As String * 100
Dim m, n As Integer

    '-------------------- Condition Setup (One Time) -------------------

    txtRslt.SelText = "Harmonics" & vbCrLf & vbCrLf

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "RO ON; RO 0 DB")                'Level Offset
    Call ibwrt(ud, "RL 0 DB")                       'Reference Level
    Call ibwrt(ud, "DET POS")
    Call ibwrt(ud, "RB 1MZ; VB 1MZ")
    
    Call ibwrt(ud, "HARMNUM 3")           ' Marmonics Number
    Call ibwrt(ud, "HRMFNDON, 2GZ")       ' Fundamental Frequency
    Call ibwrt(ud, "HARM ON")             ' Harmonics ON
    
    '--------------------- Measurement ---------------------------------
    
    Call ibwrt(ud, "TS")                  ' Measurement
    
    Call ibwrt(ud, "HARM?")               ' Data?

    buf = ""
    ibrd ud, buf
    txtRslt.SelText = buf & vbCrLf        ' Harmonics nember
    m = buf

    For n = 1 To m                        ' Data
       buf = ""
       ibrd ud, buf
       txtRslt.SelText = buf & vbCrLf
    Next n

    Call ibwrt(ud, "HARM OFF; CONTS")     ' End of Measurement
    

End Sub


Sub spurious_fix()

Dim buf As String * 100
Dim Freqtable(10) As Double
Dim FreqNumber As Integer
Dim m, n As Integer

    '-------------------- Frequency Table Setup -----------------------
    
    FreqNumber = 8                          ' Spurious Table
    Freqtable(1) = 1000
    Freqtable(2) = 2000
    Freqtable(3) = 3000
    Freqtable(4) = 4000
    Freqtable(5) = 5000
    Freqtable(6) = 6000
    Freqtable(7) = 7000
    Freqtable(8) = 8000
    
    
    '-------------------- Condition Setup (One Time) -------------------
    
    txtRslt.SelText = "Spurious: Fixed Frequency Mode" & vbCrLf & vbCrLf
    
    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "RO ON; RO 0 DB")                'Level Offset
    Call ibwrt(ud, "RL 0 DB")                       'Reference Level
    Call ibwrt(ud, "DET POS")
    Call ibwrt(ud, "DY 0.1")
    Call ibwrt(ud, "RB 1MZ; VB 1MZ")
    Call ibwrt(ud, "SP 10MZ")
    Call ibwrt(ud, "TS")                            ' Dummy

    '--------------------- Measurement ---------------------------------
    
    For m = 1 To FreqNumber
    
        Call ibwrt(ud, "CF" & Freqtable(m) & "MZ")
        Call ibwrt(ud, "TS")                       ' Measurement
        Call ibwrt(ud, "PS")                       ' Peak search
        Call ibwrt(ud, "MFL?")
    
        buf = ""
        ibrd ud, buf
        txtRslt.SelText = buf & vbCrLf             ' Spurious data
       
    Next m



    Call ibwrt(ud, "CONTS")                        ' Sweep countinue



End Sub

Private Sub Command2_Click()

    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
        
    '                                   'Measurement
    Call spurious_table
    ' Call harmonics
    ' Call spurious_fix
    
    Call ibonl(ud, 0)                   'GPIB device 
    Call ibonl(0, 0)                    'GPIB board 


End Sub

Private Sub Command3_Click()

    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
    
    '                                   'Measurement
    ' Call spurious_table
    Call harmonics
    ' Call spurious_fix
    
    Call ibonl(ud, 0)                   'GPIB device 
    Call ibonl(0, 0)                    'GPIB board 


End Sub

Private Sub Command4_Click()

    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
    
    '                                   'Measurement
    ' Call spurious_table
    ' Call harmonics
    Call spurious_fix
    
    Call ibonl(ud, 0)                   'GPIB device 
    Call ibonl(0, 0)                    'GPIB board 


End Sub
