VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Spurious Meas"
   ClientHeight    =   6060
   ClientLeft      =   2760
   ClientTop       =   2160
   ClientWidth     =   6450
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6060
   ScaleWidth      =   6450
   Begin VB.CheckBox chkAvg 
      Caption         =   "Averaging"
      Height          =   255
      Left            =   4860
      TabIndex        =   13
      Top             =   960
      Width           =   1335
   End
   Begin VB.TextBox txtROfs 
      Height          =   270
      Left            =   2700
      TabIndex        =   8
      Text            =   "0"
      Top             =   960
      Width           =   1095
   End
   Begin VB.TextBox txtRef 
      Height          =   270
      Left            =   2700
      TabIndex        =   7
      Text            =   "20"
      Top             =   600
      Width           =   1095
   End
   Begin VB.OptionButton optMode 
      Caption         =   "2G"
      Height          =   195
      Index           =   1
      Left            =   5340
      TabIndex        =   6
      Top             =   360
      Value           =   -1  'True
      Width           =   915
   End
   Begin VB.OptionButton optMode 
      Caption         =   "800M"
      Height          =   195
      Index           =   0
      Left            =   5340
      TabIndex        =   5
      Top             =   120
      Width           =   915
   End
   Begin VB.TextBox txtCarr 
      Height          =   270
      Left            =   2700
      TabIndex        =   2
      Text            =   "1940"
      Top             =   180
      Width           =   1095
   End
   Begin VB.TextBox txtRslt 
      BeginProperty Font 
         Name            =   "lr SVbN"
         Size            =   9
         Charset         =   128
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   4515
      Left            =   360
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   1
      Top             =   1320
      Width           =   5955
   End
   Begin VB.CommandButton Command1 
      Caption         =   "START"
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1515
   End
   Begin VB.Label Label1 
      Caption         =   "dB"
      Height          =   195
      Index           =   5
      Left            =   3900
      TabIndex        =   12
      Top             =   1020
      Width           =   615
   End
   Begin VB.Label Label1 
      Caption         =   "dBm"
      Height          =   195
      Index           =   4
      Left            =   3900
      TabIndex        =   11
      Top             =   660
      Width           =   615
   End
   Begin VB.Label Label1 
      Caption         =   "Ref.Offs:"
      Height          =   195
      Index           =   3
      Left            =   1920
      TabIndex        =   10
      Top             =   1020
      Width           =   735
   End
   Begin VB.Label Label1 
      Caption         =   "Ref.Lev:"
      Height          =   195
      Index           =   2
      Left            =   1920
      TabIndex        =   9
      Top             =   660
      Width           =   735
   End
   Begin VB.Label Label1 
      Caption         =   "Carrier:"
      Height          =   195
      Index           =   1
      Left            =   1920
      TabIndex        =   4
      Top             =   240
      Width           =   735
   End
   Begin VB.Label Label1 
      Caption         =   "MHz"
      Height          =   195
      Index           =   0
      Left            =   3900
      TabIndex        =   3
      Top             =   240
      Width           =   615
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Const Tx8Start As Double = 815000000#
Const Tx8Stop As Double = 850000000#
Const Tx2GStart As Double = 1920000000#
Const Tx2GStop As Double = 1980000000#
Const InBandOfs  As Double = 12500000#


Dim freqList() As fCell

Private Sub Command1_Click()

Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec

MeasSpur

Call ibonl(ud, 0)                   'GPIB device 
Call ibonl(0, 0)                    'GPIB board 

End Sub

Sub MeasSpur()
Dim dCarr As Double
Dim dRef As Double, dRofs As Double
Dim iMode As Integer    '0=800M
Dim i, j, fBase As Double
Dim sTmp As String * 50
Dim dFrslt As Double, dLrslt

Dim sHDisp As String * 20, sFDisp As String * 13, sLDisp As String * 13

If Trim(txtCarr) = "" Or Trim(txtRef) = "" Or Trim(txtROfs) = "" Then Exit Sub

dCarr = Val(txtCarr) * 1000000#
dRef = Val(txtRef)
dRofs = Val(txtROfs)
iMode = IIf(optMode(0).value = False, 1, 0)

Erase freqList
i = 0
ReDim freqList(i)
freqList(i).str = 30000000#
If iMode = 0 Then   '800M
    freqList(i).stp = dCarr - InBandOfs
    i = i + 1
    ReDim Preserve freqList(i)
    freqList(i).str = dCarr + InBandOfs
    freqList(i).stp = 2100000000#
    
    i = i + 1
    ReDim Preserve freqList(i)
    freqList(i).str = 2000000000#
    freqList(i).stp = 3100000000#
    
   ' i = i + 1
   ' ReDim Preserve freqList(i)
   ' freqList(i).str = 3000000000#
   ' freqList(i).stp = 4100000000#
   
Else
    freqList(i).stp = 1100000000#
    i = i + 1
    ReDim Preserve freqList(i)
    freqList(i).str = 1000000000#
    freqList(i).stp = dCarr - InBandOfs

    i = i + 1
    ReDim Preserve freqList(i)
    freqList(i).str = dCarr + InBandOfs
    freqList(i).stp = 3100000000#
    
    fBase = 3000000000#
    For j = 1 To 3
        i = i + 1
        ReDim Preserve freqList(i)
        freqList(i).str = fBase
        freqList(i).stp = fBase + 1100000000#
        fBase = fBase + 1000000000#
    Next j
End If

Call ibwrt(ud, "DY 0.1")
Call ibwrt(ud, "RB 1MZ VB 1MZ")
Call ibwrt(ud, "DET POS")
Call ibwrt(ud, "RO ON RO " & Format(dRofs) & "DB")
Call ibwrt(ud, "RL " & Format(dRef) & "DB")
Call ibwrt(ud, "SI")                            'Sweep STOP
Call ibwrt(ud, "AGS")                           'AVG off
txtRslt.SelText = "Spurious" & vbCrLf
For j = LBound(freqList) To UBound(freqList)
    Call ibwrt(ud, "FB " & Format(freqList(j).stp) & "HZ")
    Call ibwrt(ud, "FA " & Format(freqList(j).str) & "HZ")

    If chkAvg.value = 0 Then                    'AverageȂꍇ
        Call ibwrt(ud, "TS")                            'Sweep once
    Else                                        'Averageꍇ
        Call ibwrt(ud, "AGSGL")                         'AVG single
        Call ibwrt(ud, "AG 10")                         'AVG 10 times
        Call ibwrt(ud, "AGR")                           'AVG start
        Call ibwrt(ud, "CONTS")                         'Sweep continue
        WaitAvgEnd                                      'Wait AVG end
    End If
    Call ibwrt(ud, "PS")
    Call ibwrt(ud, "MF?")
    Call ibrd(ud, sTmp)
    dFrslt = Val(sTmp)
    Call ibwrt(ud, "ML?")
    Call ibrd(ud, sTmp)
    dLrslt = Val(sTmp)
    sHDisp = Format(freqList(j).str / 1000000#) & "MHz---" & Format(freqList(j).stp / 1000000#) & "MHz"
    RSet sFDisp = Format(dFrslt / 1000000#, "####0.000") & "MHz"
    RSet sLDisp = Format(dLrslt, "####0.00") & "dBm"
    txtRslt.SelText = sHDisp & sFDisp & sLDisp & vbCrLf
Next j
Call ibwrt(ud, "AAVG OFF")

End Sub

